#include "SDL/SDL.h" //Header-ul SDL
#include "SDL/SDL_ttf.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_mixer.h"
#include "functions.h"
#include "clase.h"


void blit_surface(SDL_Surface *src, SDL_Surface *dest, int x, int y, SDL_Rect *clip){
	SDL_Rect pos;
	//Un SDL_Rect are 4 campuri: x, y, w (width) si h (height)
	pos.x = x;
	pos.y = y;
	SDL_BlitSurface(src, clip, dest, &pos);
}

SDL_Surface* load_image(char* filename){
	SDL_Surface* img_raw = IMG_Load(filename);
	SDL_Surface* img_opt = SDL_DisplayFormatAlpha(img_raw);
	SDL_FreeSurface(img_raw);
	return img_opt;
}


void close_sdl()
{
    SDL_FreeSurface(screen);
    SDL_Quit();
}

