#include "include\\SDL\\SDL.h"
#include <fstream>
#include <string>
#include "include\\SDL\\SDL_ttf.h"

// define-uri
#define NRNIVELE 10

// Surfaces
// menu
SDL_Surface * background = NULL;
SDL_Surface * final = NULL;
SDL_Surface * fundal = NULL;
SDL_Surface* background_instr = NULL;
SDL_Surface* background_nivele = NULL;
SDL_Surface* buton_start = NULL;
SDL_Surface* buton_iesi = NULL;
SDL_Surface* buton_instructiuni = NULL;
SDL_Surface* buton_nivele = NULL;
SDL_Surface* message = NULL;
SDL_Surface* tema = NULL;
// screen
SDL_Surface* screen = NULL;
// levels
SDL_Surface* omulet = NULL;
SDL_Surface* om = NULL;
SDL_Surface* wall = NULL;
SDL_Surface* cutie = NULL;
SDL_Surface* centru = NULL;
SDL_Surface* om_jos = NULL;

//The event structure
SDL_Event event;

// fonts
TTF_Font *font = NULL;
SDL_Color textColor = { 65, 65, 65 };

Uint8 *keystates = SDL_GetKeyState( NULL );

SDL_Surface *load_image( std::string filename )
{
    SDL_Surface* loadedImage = NULL;
    SDL_Surface* optimizedImage = NULL;
    loadedImage = SDL_LoadBMP( filename.c_str() );
    if( loadedImage != NULL )
    {   optimizedImage = SDL_DisplayFormat( loadedImage );
        SDL_FreeSurface( loadedImage );
    }
    return optimizedImage;
}
void apply_surface( int x, int y, SDL_Surface* source, SDL_Surface* destination )
{
    SDL_Rect offset;
    offset.x = x;
    offset.y = y;
    SDL_BlitSurface( source, NULL, destination, &offset );
}
bool init()
{
    if( SDL_Init( SDL_INIT_EVERYTHING ) == -1 )
        {return false;}
    screen = SDL_SetVideoMode( 1024,768, 32, SDL_SWSURFACE);
    if( screen == NULL )
        {return false;}

    if( TTF_Init() == -1 )
    {
        return false;
    }

    SDL_WM_SetCaption( "Storage Trouble", NULL );
        return true;
}

// fisierul
bool load_files()
{
    wall = load_image( "images/wall.bmp" );
    cutie = load_image( "images/box.bmp" );
    centru= load_image( "images/centru.bmp");
    background = load_image( "images/menu_background.bmp" );
    buton_start = load_image("images/menu_start.bmp");
    buton_instructiuni = load_image( "images/menu_instructiuni.bmp" );
    buton_iesi = load_image("images/menu_iesi.bmp");
    buton_nivele = load_image("images/menu_nivele.bmp");

    //If everything loaded fine
    return true;
}

void clean_up()
{
    SDL_FreeSurface( buton_start );
    SDL_FreeSurface( buton_instructiuni );
    //SDL_FreeSurface( buton_nivele );
    SDL_FreeSurface( buton_iesi );
    SDL_FreeSurface( wall );
    SDL_FreeSurface( cutie );
    SDL_FreeSurface( centru );
    SDL_FreeSurface( background );
    SDL_FreeSurface( message );
    SDL_FreeSurface( final );
    SDL_FreeSurface( fundal );
    SDL_FreeSurface( tema );
    SDL_FreeSurface( omulet );
    SDL_FreeSurface( om_jos );

    TTF_CloseFont( font );

    TTF_Quit();
    //Quit SDL
    SDL_Quit();
}

using namespace std;

ifstream fin("fisiere/nivel.in");

short int lvl[33][33],clvl[33][33],cutii[33][33],centre[33][33],ccutii[33][33];
short int i, j,  element, bt, xom, yom, nrcutii=0,reset=0,dirx,diry,gata,cxom,cyom,escape=0, nivel;
float x, y;
bool started, quit, quit_menu, termjoc;
// buton meniu
struct buton
{
    float x, y, w, h;
};
buton b_start, b_instructiuni, b_iesi;


int butoane( int x, int y)
{
    // verifica daca coordonatele pointerului sunt pe unul din butoane
    if( ( x > b_start.x ) && ( x < b_start.x + b_start.w) && ( y > b_start.y ) && ( y < b_start.y + b_start.h ) )
            {
                return 1;
            }
    else if( ( x > b_instructiuni.x ) && ( x < b_instructiuni.x + b_instructiuni.w) && ( y > b_instructiuni.y ) && ( y < b_instructiuni.y + b_instructiuni.h ) )
            {
                return 2;
            }
    /*else if( ( x > b_nivele.x ) && ( x < b_nivele.x + b_nivele.w) && ( y > b_nivele.y ) && ( y < b_nivele.y + b_nivele.h ) )
            {
                return 3;
            }*/
    else if( ( x > b_iesi.x ) && ( x < b_iesi.x + b_iesi.w) && ( y > b_iesi.y ) && ( y < b_iesi.y + b_iesi.h ) )
            {
                return 4;
            }
return 0;
}


void instr()
{
bool termina=false;

background_instr = load_image( "images/instructiuni.bmp" );
apply_surface(40, 55, background_instr, screen);
message = TTF_RenderText_Solid( font, "Pentru a reveni la meniu apasati click dreapta sau tasta Esc.", textColor );
apply_surface(100, 80, message, screen);
SDL_Flip( screen );
while( termina == false)
    {
        while( SDL_PollEvent( &event ) )
            if( event.type == SDL_MOUSEBUTTONDOWN )
                {
                    //If the left mouse button was pressed
                    if( event.button.button == SDL_BUTTON_LEFT )
                        {
                            termina = true;
                            SDL_FreeSurface( background_instr );
                            SDL_FreeSurface( message );
                            break;
                        }
                }
            if( keystates[ SDLK_ESCAPE ] )
                {
                    termina = true;
                    SDL_FreeSurface( background_instr );
                    SDL_FreeSurface( message );
                    break;
                }
    }
}

void incarca_butoane()
{
background = load_image( "images/menu_background.bmp" );
buton_start = load_image("images/menu_start.bmp");
buton_instructiuni = load_image( "images/menu_instructiuni.bmp" );
buton_iesi = load_image("images/menu_iesi.bmp");
//buton_nivele = load_image("images/menu_nivele.bmp");
}

void initbutoane()
{
b_start.x = 412; b_start.y = 300; b_start.w = 200; b_start.h = 50;
b_instructiuni.x = 412, b_instructiuni.y = 400, b_instructiuni.w = 200, b_instructiuni.h = 50;
//b_nivele.x = 412, b_nivele.y = 3*154, b_nivele.w = 200, b_nivele.h = 50;
b_iesi.x = 412, b_iesi.y = 500, b_iesi.w = 200, b_iesi.h = 50;
}

void meniu()
{
apply_surface(0, 0, background, screen);
apply_surface(412, 300, buton_start, screen);
apply_surface(412, 400, buton_instructiuni, screen);
//apply_surface(412, 3*154, buton_nivele, screen);
apply_surface(412, 500, buton_iesi, screen);
SDL_Flip( screen );
}

int main( int argc, char* args[] )
    {
        quit = false;
        if( init() == false )
            {return 1;}
        //Initializare//

        //Open the font
        font = TTF_OpenFont( "fonts/arial.ttf", 20 );
        started=false;

        wall = load_image( "images/wall.bmp" );
        cutie = load_image( "images/box.bmp" );SDL_SetColorKey(cutie, SDL_SRCCOLORKEY, SDL_MapRGB(screen->format, 255, 0, 255));
        centru= load_image( "images/centru.bmp");
        tema= load_image("images/background.bmp");
        background = load_image( "images/menu_background.bmp" );
        buton_start = load_image("images/menu_start.bmp");
        buton_instructiuni = load_image( "images/menu_instructiuni.bmp" );
        buton_iesi = load_image("images/menu_iesi.bmp");
        buton_nivele = load_image("images/menu_nivele.bmp");
        om_jos = load_image("images/om_jos.bmp");
        fundal = load_image("images/fundal.bmp");
        omulet = load_image( "images/omulet.bmp" );SDL_SetColorKey(omulet, SDL_SRCCOLORKEY, SDL_MapRGB(screen->format, 255, 0, 255));
        final = load_image("images/final.bmp");


        //********************************MENU***********************************//
        incarca_butoane();
        initbutoane();
        meniu();
        while ( quit == false)
        {while( quit_menu == false )
            {
                termjoc=false;
                nivel=1;
                while ( SDL_PollEvent( &event ) )
                {
                    if( event.type == SDL_MOUSEBUTTONDOWN )
                    {
                        //daca click stanga este apasat
                        if( event.button.button == SDL_BUTTON_LEFT )
                        {
                            // coord mouse-ului
                            x = event.button.x;
                            y = event.button.y;
                            bt = butoane( x, y );
                            if( bt == 1 )
                                {
                                    quit_menu=true;
                                    started=true;
                                    break;
                                }
                            else if( bt==2 )
                                {
                                    instr();
                                    meniu();
                                    continue;
                                }
                            /*else if ( bt==3 )
                                {
                                    nivele();
                                    meniu();
                                    continue;
                                }*/
                            else if ( bt==4 )
                                {
                                    quit = true;
                                    quit_menu=true;
                                    break;
                                }
                        }
                    }
                    if( event.type == SDL_QUIT )
                        {
                            quit = true;
                            break;
                        }
                }
            }
        if( quit == true ) clean_up();

        ////////////// JOCUL ///////////////////
        if( started )
            while( termjoc == false )//cat timp ma joc
                {
                    if (escape)
                        fin.open ("fisiere/nivel.in");
                    escape=0;
                    for(i=0;i<24;i++)
                        for(j=0;j<32;j++)
                            {lvl[i][j]=0;cutii[i][j]=0;centre[i][j]=0;}
                    nrcutii=0;
                    for(i=0;i<24;i++)
                        for(j=0;j<32;j++)
                            {
                                ccutii[i][j]=0;clvl[i][j]=0;
                                fin>>element;
                                if(element==0){lvl[i][j]=element;clvl[i][j]=element;apply_surface(  j*32,i*32, fundal, screen );continue;}
                                if(element==1)
                                    {
                                        apply_surface(  j*32,i*32, wall, screen );
                                        SDL_Flip( screen );
                                        clvl[i][j]=lvl[i][j]=element;
                                        continue;
                                    }
                                if(element==2)
                                    {
                                        apply_surface( j*32,i*32, fundal, screen );
                                        apply_surface( j*32,i*32, cutie, screen );
                                        SDL_Flip( screen );

                                        ccutii[i][j]=cutii[i][j]=element;
                                        nrcutii++;
                                        lvl[i][j]=0;
                                        clvl[i][j]=0;
                                        continue;
                                    }
                                if(element==3)
                                    {
                                        apply_surface(  j*32,i*32, centru, screen );
                                        SDL_Flip( screen );
                                        centre[i][j]=element;
                                        continue;
                                    }
                                if(element==4)
                                    {
                                        apply_surface( j*32, i*32, omulet, screen );
                                        xom=j;yom=i;
                                        cxom=xom;cyom=yom;
                                        continue;
                                    }
                            }
                        gata=nrcutii;
                    //********************************************************8*******************//
                    while(1)
                    //cat timp suntem intrun nivel
                        {

                            if(reset==1)
                                {
                                    xom=cxom;yom=cyom;
                                    apply_surface(0,0,tema,screen);
                                    for(i=0;i<24;i++)
                                        for(j=0;j<32;j++)
                                            {
                                                lvl[i][j]=clvl[i][j];
                                                cutii[i][j]=ccutii[i][j];
                                                if(lvl[i][j]==1)
                                                    apply_surface(j*32,i*32,wall,screen);
                                                if(cutii[i][j]==2)
                                                    apply_surface(j*32,i*32,cutie,screen);
                                                if(centre[i][j]==3)
                                                    apply_surface(j*32,i*32,centru,screen);
                                            }
                                    apply_surface(xom*32,yom*32,om,screen);
                                    SDL_Flip( screen );
                                }
                        //******************************************************************************//

                            reset=0;
                            gata=0;
                            for(i=0;i<24;i++)
                                for(j=0;j<32;j++)
                                    if(centre[i][j]!=0)
                                        if(cutii[i][j]!=0)
                                            gata++;
                            if(gata==nrcutii)
                                {
                                    SDL_Delay( 800 );
                                    nivel++;
                                    if (nivel==NRNIVELE+1)
                                        {
                                            termjoc=true;
                                            apply_surface(0, 0, final, screen);
                                            SDL_Delay( 5000 );
                                            clean_up();
                                        }
                                    break;}
                            dirx=0;diry=0;
                            while( SDL_PollEvent( &event ) )
                                {
                                    if( event.type == SDL_KEYDOWN )
                                        {
                                            switch( event.key.keysym.sym )
                                            {
                                                case SDLK_ESCAPE : escape=1;break;
                                                case SDLK_r : reset=1;break;
                                                case SDLK_UP :dirx=0;diry=-1;om = load_image( "images/om_sus.bmp" );SDL_SetColorKey(om, SDL_SRCCOLORKEY, SDL_MapRGB(screen->format, 255, 0, 255));break;
                                                case SDLK_DOWN :dirx=0;diry=1;om = load_image( "images/om_jos.bmp" );SDL_SetColorKey(om, SDL_SRCCOLORKEY, SDL_MapRGB(screen->format, 255, 0, 255));break;
                                                case SDLK_RIGHT :dirx=1;diry=0;om = load_image( "images/om_dreapta.bmp" );SDL_SetColorKey(om, SDL_SRCCOLORKEY, SDL_MapRGB(screen->format, 255, 0, 255));break;
                                                case SDLK_LEFT :dirx=-1;diry=0;om = load_image( "images/om_stanga.bmp" );SDL_SetColorKey(om, SDL_SRCCOLORKEY, SDL_MapRGB(screen->format, 255, 0, 255));break;
                                                default : ;

                                            }
                                        }
                                }
                            if (escape) {meniu(); quit_menu=false; started=false; break; }
                            if(dirx!=0||diry!=0)
                                {
                                    if(lvl[yom][xom]==0&&(centre[yom][xom]==0))
                                    //DACA OMUL E PE UN PATRATEL LIBER
                                        {
                                            if(cutii[yom+diry][xom+dirx]==2)
                                            //DACA TRB SA MUTE O CUTIE
                                                {

                                                    if(cutii[yom+2*diry][xom+2*dirx]==2)
                                                            continue;
                                                    if(centre[yom+diry][xom+dirx]==0)
                                                    //DACA CUTIA SE AFLA PE FUNDAL
                                                        {
                                                            //DACA AVEM PLUS DUPA ASTA
                                                            if(centre[yom+2*diry][xom+2*dirx]==3&&lvl[yom+2*diry][xom+2*dirx]==0)
                                                                {
                                                                    apply_surface(xom*32,yom*32 ,fundal, screen );
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32 ,fundal, screen );
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32, om, screen);

                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32, cutie, screen );
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }
                                                            if(centre[yom+2*diry][xom+2*dirx]==0&&lvl[yom+2*diry][xom+2*dirx]==0)
                                                            //DACA AVEM FUNDAL DUPA ASTA
                                                                {
                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32, cutie, screen );
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32, fundal, screen);
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32, om, screen);
                                                                    apply_surface(xom*32,yom*32 ,fundal, screen );
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }

                                                            else continue;
                                                        }

                                                    if(centre[yom+diry][xom+dirx]==3)
                                                    //DACA CUTIA SE AFLA PE PLUS
                                                        {
                                                            if(centre[yom+diry*2][xom+dirx*2]==0&&lvl[yom+diry*2][xom+dirx*2]==0)
                                                            //DACA AVEM FUNDAL DUPA ASTA
                                                                {
                                                                    apply_surface(xom*32,yom*32,fundal,screen);

                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,om,screen);
                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32,cutie,screen);
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }
                                                            //DACA AVEM PLUS DUPA ASTA
                                                            if(centre[yom+2*diry][xom+2*dirx]==3&&lvl[yom+2*diry][xom+2*dirx]==0)
                                                                {
                                                                    apply_surface(xom*32,yom*32,fundal,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,fundal,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,om,screen);
                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32,cutie,screen);
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }
                                                            else continue;
                                                        }

                                                }
                                            if(lvl[yom+diry][xom+dirx]==0)
                                            //DACA AVEM FUNDAL PE PATRATICA CARE TREBUIE SA MUTAM
                                                {
                                                    apply_surface( xom*32,yom*32, fundal, screen );//sterge omuletul si pune fundal
                                                    xom+=dirx;yom+=diry;
                                                    apply_surface( xom*32,yom*32, om, screen );
                                                    SDL_Flip(screen);
                                                    continue;
                                                }
                                            if(cutii[yom+diry][xom+dirx]==3)
                                            //DACA AVEM PLUS
                                                {
                                                    apply_surface( xom*32,yom*32, fundal, screen );//sterge omuletul si pune fundal
                                                    apply_surface( (xom+dirx)*32,(yom+diry)*32, om, screen );
                                                    xom+=dirx;yom+=diry;
                                                    SDL_Flip(screen);
                                                    continue;
                                                }

                                        }
                                    if(centre[yom][xom]==3)
                                    //DACA OMUL STA PE PLUS
                                        {
                                            if(cutii[yom+diry][xom+dirx]==2)
                                            //DACA TRB SA MUTE O CUTIE
                                                {
                                                    if(cutii[yom+2*diry][xom+2*dirx]==2)
                                                                continue;
                                                    if(lvl[yom+2*diry][xom+2*dirx]==1)
                                                                continue;
                                                    if(centre[yom+diry][xom+dirx]==0)
                                                    //DACA CUTIA SE AFLA PE FUNDAL
                                                        {
                                                            if(centre[yom+2*diry][xom+2*dirx]==0&&lvl[yom+2*diry][xom+2*dirx]==0)
                                                            //DACA AVEM FUNDAL DUPA ASTA
                                                                {
                                                                    apply_surface(xom*32,yom*32,fundal,screen);
                                                                    apply_surface(xom*32,yom*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,fundal,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,om,screen);
                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32,cutie,screen);
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }
                                                            //DACA AVEM PLUS DUPA ASTA
                                                            if(centre[yom+2*diry][xom+2*dirx]==3&&lvl[yom+2*diry][xom+2*dirx]==0)
                                                                {
                                                                    apply_surface(xom*32,yom*32,fundal,screen);
                                                                    apply_surface(xom*32,yom*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,fundal,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,om,screen);
                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32,cutie,screen);
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }

                                                        }

                                                    if(centre[yom+diry][xom+dirx]==3)
                                                    //DACA CUTIA SE AFLA PE PLUS
                                                        {
                                                            if(centre[yom+2*diry][xom+2*dirx]==0&&lvl[yom+2*diry][xom+2*dirx]==0)
                                                            //DACA AVEM FUNDAL DUPA ASTA
                                                                {
                                                                    apply_surface(xom*32,yom*32,fundal,screen);
                                                                    apply_surface(xom*32,yom*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,fundal,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,om,screen);
                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32,cutie,screen);
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }
                                                            //DACA AVEM PLUS DUPA ASTA
                                                            if(centre[yom+2*diry][xom+2*dirx]==3&&lvl[yom+2*diry][xom+2*dirx]==0)
                                                                {
                                                                    apply_surface(xom*32,yom*32,fundal,screen);
                                                                    apply_surface(xom*32,yom*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,fundal,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,centru,screen);
                                                                    apply_surface((xom+dirx)*32,(yom+diry)*32,om,screen);
                                                                    apply_surface((xom+dirx*2)*32,(yom+diry*2)*32,cutie,screen);
                                                                    cutii[yom+diry*2][xom+dirx*2]=2;
                                                                    cutii[yom+diry][xom+dirx]=0;
                                                                    xom+=dirx;yom+=diry;
                                                                    SDL_Flip(screen);
                                                                    continue;
                                                                }
                                                            else continue;
                                                        }

                                                }
                                            if(lvl[yom+diry][xom+dirx]==0)
                                            //DACA AVEM FUNDAL PE PATRATICA CARE TREBUIE SA MUTAM
                                                {
                                                    apply_surface( xom*32,yom*32, fundal, screen );
                                                    apply_surface( xom*32,yom*32, centru, screen );
                                                    apply_surface( (xom+dirx)*32,(yom+diry)*32, om, screen );
                                                    xom+=dirx;yom+=diry;
                                                    SDL_Flip(screen);
                                                    continue;
                                                }
                                            if(cutii[yom+diry][xom+dirx]==3)
                                            //DACA AVEM PLUS PE PATRATICA CARE TREBUIE SA MUTAM
                                                {
                                                    apply_surface( xom*32,yom*32, fundal, screen );
                                                    apply_surface( xom*32,yom*32, centru, screen );
                                                    apply_surface( (xom+1)*32,(yom+1)*32, om, screen );
                                                    xom+=dirx;yom+=diry;
                                                    SDL_Flip(screen);
                                                    continue;
                                                }
                                        }
                                }

                        }
                    if (started == false) { fin.close(); break;}
                }
        }
        SDL_Delay( 1000 );
        SDL_Quit();
        return 0;
    }
