#include "SDL/SDL.h"
#include "SDL\\SDL_image.h"
#include <cstring>
#include <iostream>
#include <fstream>
#define marimecaramida_X 32
#define marimecaramida_Y 32
using namespace std;
void init_sdl(bool is_fullscreen);
void close_sdl();
void drawImage(SDL_Surface *image, int x, int y);
void drawmap();
int verifharta();
bool verifcollis( SDL_Rect A, SDL_Rect B );
void loadmap( string nume);
SDL_Surface* screen;
SDL_Surface* img;
SDL_Surface* img2,*perete,*coins,*omugalben,*temp,*bonus;
SDL_Surface *load_image( string filename );

struct level
{
    int tile[marimecaramida_Y][marimecaramida_X];

} level;
int postartx,postarty;
int culoare;
SDL_Rect move1,pacmanimage;
int dir[4],scor;
SDL_Rect wall;
int main(int argc,char *args[])
{
    init_sdl(0);
    SDL_Event eveniment;
    img=load_image("background.jpg");
    img2=load_image("backgroundlevel.jpg");
    perete=load_image("perete.jpg");

    temp   = load_image("pac.png");
	omugalben = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);
	culoare = SDL_MapRGB(screen->format, 255,255, 255);
	SDL_SetColorKey(omugalben, SDL_SRCCOLORKEY | SDL_RLEACCEL, culoare);

	temp   = load_image("banut.png");
	coins = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);
	culoare = SDL_MapRGB(screen->format, 0,0,0);
	SDL_SetColorKey(coins, SDL_SRCCOLORKEY | SDL_RLEACCEL, culoare);

    temp   = load_image("banutbonus.png");
	bonus = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);
	culoare = SDL_MapRGB(screen->format,  255,255, 255);
	SDL_SetColorKey(bonus, SDL_SRCCOLORKEY | SDL_RLEACCEL, culoare);

    loadmap("level1.dat");

    move1.x = postartx;
	move1.y = postarty;
	pacmanimage.x = 128;
	pacmanimage.y = 0;
	pacmanimage.w = 32;
	pacmanimage.h = 32;
	int coordx,coordy;
    while(1){
        SDL_BlitSurface(img, NULL, screen, NULL);
        SDL_Flip(screen);
        while(SDL_PollEvent(&eveniment))
        {
            if(eveniment.type == SDL_QUIT){
                    close_sdl();
                    return 0;
            }
            if ( eveniment.key.keysym.sym == SDLK_ESCAPE ){
                    close_sdl();
                    return 0;
            }
            if(eveniment.type == SDL_KEYDOWN){
                if( eveniment.key.keysym.sym == SDLK_p )SDL_FillRect(img,NULL,0x000000);
                if( eveniment.key.keysym.sym == SDLK_h )SDL_BlitSurface(img, NULL, screen, NULL);
                if( eveniment.key.keysym.sym == SDLK_e ){ close_sdl(); return 0; }

            }
            if(eveniment.type == SDL_KEYUP){
                if( eveniment.key.keysym.sym == SDLK_p )
                    while(1){
                        SDL_BlitSurface(img2, NULL, screen, NULL);
                        SDL_BlitSurface(omugalben, &pacmanimage, screen, &move1);
                        drawmap();
                        SDL_Flip(screen);
                        while(SDL_PollEvent(&eveniment)){
                            if(eveniment.type == SDL_QUIT){
                            close_sdl(); return 0;
                            }
                            if(eveniment.type == SDL_KEYDOWN){
                                    if(eveniment.key.keysym.sym==SDLK_UP)dir[0] = 1;
                                    if(eveniment.key.keysym.sym==SDLK_LEFT)dir[1] = 1;
                                    if(eveniment.key.keysym.sym==SDLK_DOWN)dir[2] = 1;
                                    if(eveniment.key.keysym.sym==SDLK_RIGHT)dir[3] = 1;
                            }
                            if(eveniment.type == SDL_KEYUP){
                                    if(eveniment.key.keysym.sym==SDLK_UP)dir[0] = 0;
                                    if(eveniment.key.keysym.sym==SDLK_LEFT)dir[1] = 0;
                                    if(eveniment.key.keysym.sym==SDLK_DOWN)dir[2] = 0;
                                    if(eveniment.key.keysym.sym==SDLK_RIGHT)dir[3] = 0;
                            }
                        if ( eveniment.key.keysym.sym == SDLK_ESCAPE ){
                            close_sdl(); return 0;
                            }

                        }
                        if(dir[0]){
                                if ( pacmanimage.x == 0 )pacmanimage.x = 32;
                                    else pacmanimage.x = 0;
                            move1.y --;
                            }
                            if(dir[1]){
                                if ( pacmanimage.x == 192 )pacmanimage.x = 224;
                                    else pacmanimage.x = 192;
                            move1.x --;
                            }
                            if(dir[2]){
                                if ( pacmanimage.x == 128 )
                                    pacmanimage.x = 160;
                                    else pacmanimage.x = 128;
                            move1.y ++;
                            }
                            if(dir[3]){
                                if ( pacmanimage.x == 64 )pacmanimage.x = 96;
                                else pacmanimage.x = 64;
                            move1.x ++;
                            }
                        for (coordx=0;coordx<marimecaramida_X;coordx++)
                            for (coordy=0;coordy<marimecaramida_Y;coordy++){
                                if ( level.tile[coordy][coordx]==1 ){
                                    wall.x=coordx*40;
                                    wall.y=coordy*40;
                                    wall.h=40;
                                    wall.w=40;
                                    if(dir[0]&&verifcollis( move1, wall ))move1.y++;
                                    if(dir[1]&&verifcollis( move1, wall ))move1.x++;
                                    if(dir[2]&&verifcollis( move1, wall ))move1.y--;
                                    if(dir[3]&&verifcollis( move1, wall ))move1.x--;
                                }
                                if(level.tile[coordy][coordx]==2 ){
                                    wall.x=coordx*40;
                                    wall.y=coordy*40;
                                    wall.h=10;
                                    wall.w=5;
                                    if(verifcollis( move1, wall )){
                                        level.tile[coordy][coordx]=0;
                                        scor+=20;
                                        if(!scor%100){
                                            int timp,lanimx=rand()%32,lanimy=rand()%32;
                                            level.tile[lanimx*40][lanimy*40]=4;
                                            for(timp=0;timp<=3000;timp+=0.5);
                                            if(timp==30)
                                                level.tile[lanimx][lanimy]=0;
                                            SDL_Flip(screen);
                                        }

                                    }
                                }
                            }

                    }
                if( eveniment.key.keysym.sym == SDLK_h )
                    while(1){
                        SDL_BlitSurface(img, NULL, screen, NULL);
                        SDL_Flip(screen);
                        while(SDL_PollEvent(&eveniment)){
                            if(eveniment.type == SDL_QUIT){
                            close_sdl(); return 0;
                        }
                        if ( eveniment.key.keysym.sym == SDLK_ESCAPE ){
                            close_sdl(); return 0;
                            }
                        }

                    }

            }

        }
        SDL_Flip(screen);
        SDL_Delay(10);
    }
    close_sdl();
    return 0;
}

void init_sdl(bool is_fullscreen){
    SDL_Init(SDL_INIT_EVERYTHING);
    if(is_fullscreen==0){
        screen=SDL_SetVideoMode(800,600,32,0);
    }
    else{
        screen=SDL_SetVideoMode(800,600,32,SDL_FULLSCREEN);
    }
}

void close_sdl(){
    SDL_Quit();
}

SDL_Surface *load_image( string filename )
{
    SDL_Surface* loadedImage = NULL;
    SDL_Surface* optimizedImage = NULL;
    loadedImage = IMG_Load(filename.c_str());
    if(loadedImage != NULL)
    {
        optimizedImage = SDL_DisplayFormat( loadedImage );
        SDL_FreeSurface( loadedImage );
    }
    return optimizedImage;
}
void loadmap( string nume)
{
    int nrharta;
    int x, y;
    ifstream mp(nume.c_str());
    for (y=0;y<marimecaramida_Y;y++)
    {
        for (x=0;x<marimecaramida_X;x++)
        {
            mp>>level.tile[y][x];
            if (level.tile[y][x]==3){
                postartx=x*40;
                postarty=y*40;

            }
        }
    }
    mp.close();
}
void drawmap()
{
    int x, y;
    for (y=0;y<marimecaramida_Y;y++)
    {
        for (x=0;x<marimecaramida_X;x++)
        {
            if (level.tile[y][x]==1)drawImage(perete, x * 40, y * 40);
            if (level.tile[y][x]==2)drawImage(coins, x * 40, y * 40);
            if (level.tile[y][x]==4)drawImage(bonus, x * 40, y * 40);
        }
    }
}
void drawImage(SDL_Surface *image, int x, int y)
{
	SDL_Rect dest;
	dest.x = x;
	dest.y = y;
	dest.w = 32;
	dest.h = 32;
	SDL_BlitSurface(image, NULL, screen, &dest);
}
bool verifcollis( SDL_Rect A, SDL_Rect B )
{
    int leftA, leftB;
    int rightA, rightB;
    int topA, topB;
    int bottomA, bottomB;

    leftA = A.x;
    rightA = A.x + A.w;
    topA = A.y;
    bottomA = A.y + A.h;

    leftB = B.x;
    rightB = B.x + B.w;
    topB = B.y;
    bottomB = B.y + B.h;

    if( bottomA<= topB )return false;
    if( topA>=bottomB )return false;
    if( rightA<=leftB )return false;
    if( leftA>=rightB )return false;

    return true;
}
int verifharta(){
    int x, y,done=1;
    for (y=0;y<marimecaramida_Y;y++)
        for (x=0;x<marimecaramida_X;x++)
            if (level.tile[y][x])!done;
    if(done)return 1;
    else
    return 0;
}
