#include <fstream>
#include <cstring>

using namespace std;

#define MAX_LINE   10005
#define MAX_numSir 40000
#define MAX_DIG    1000000

 int Sum[MAX_DIG];
 int lgSum = 1;

 int sir[MAX_DIG];
 int lgsir = 1;

 char linie[MAX_LINE];
 char numSir[MAX_numSir];
 char invSir[MAX_DIG + 5];

 int isLower(char c) {
    return (c >= 'a' && c <= 'z');
}

 int cifimp(char c) {
    return (c=='1' || c=='3' || c=='5' || c=='7' || c=='9');
}

/* adauga cifrele ASCII ale lui car (97..122) in numSir */
 void constructie_sir(int car, int &pos) {
    if (car >= 100) {
        numSir[pos++] = (char)('0' + (car / 100));
        numSir[pos++] = (char)('0' + ((car / 10) % 10));
        numSir[pos++] = (char)('0' + (car % 10));
    } else {
        numSir[pos++] = (char)('0' + (car / 10));
        numSir[pos++] = (char)('0' + (car % 10));
    }
}

/* Sum += siraux (ambele sunt in ordine inversa) */
 void AdunNrMare(const int *siraux, int lgaux) {
    int T = 0;
    int maxlg;
    if(lgSum > lgaux)  maxlg = lgSum;
        else maxlg = lgaux;

    int i;
    for (i=0; i < maxlg || T; i++) {
        int s = T;
        if (i < lgSum)  s += Sum[i];
        if (i < lgaux) s += siraux[i];

        if (i < lgSum) Sum[i] = s % 10;
        else {
            Sum[i] = s % 10;
            lgSum++;
        }
        T = s / 10;
    }

    if (i > lgSum) lgSum = i;
    while (lgSum > 1 && Sum[lgSum - 1] == 0) lgSum--;
}

/* sir = Sum * m (m numar mic) */
 void prodNrMare(int m) {
    if (m == 0) { sir[0] = 0; lgsir = 1; return; }

    long long T = 0;
    int i;
    for (i = 0; i < lgSum; i++) {
        long long prod = Sum[i] * m + T;
        sir[i] = (int)(prod % 10);
        T = prod / 10;
    }
    lgsir = lgSum;

    while (T) {
        sir[lgsir++] = (int)(T % 10);
        T /= 10;
    }

    while (lgsir > 1 && sir[lgsir - 1] == 0) lgsir--;
}

int main() {
    ifstream fin("egipt.in");
    ofstream fout("egipt.out");

    int n;
    fin >> n;
    fin.getline(linie, MAX_LINE);
    // initial suma = 0
    Sum[0] = 0;
    lgSum = 1;

    for (int k = 0; k < n; k++) {
        fin.getline(linie, MAX_LINE);

        int pos = 0; // lungime numSir
        for (int i = 0; linie[i] != '\0'; i++) {
            char c = linie[i];
            if (isLower(c)) {
                constructie_sir((int)c, pos);
                if (pos >= MAX_numSir - 5) break;
            }
        }
        numSir[pos] = '\0';

        if (pos == 0) {
            int tmp0[1] = {0};
            AdunNrMare(tmp0, 1);
            continue;
        }

        int siraux[MAX_numSir];
        int L = (int)strlen(numSir);
        for (int i = 0; i < L; i++) {
            siraux[i] = (int)(numSir[L - 1 - i] - '0');
        }
        AdunNrMare(siraux, L);
    }

    int year;
    fin >> year;

    prodNrMare(year);

    for (int i = 0; i < lgsir; i++) {
        invSir[i] = (char)('0' + sir[lgsir - 1 - i]);
    }
    invSir[lgsir] = '\0';

    int lgmax = 0, start = -1;
    int lg = 0, curStart = 0;

    for (int i = 0; invSir[i] != '\0'; i++) {
        if (cifimp(invSir[i])) {
            if (lg == 0) curStart = i;
            lg++;
            if (lg > lgmax) {
                lgmax = lg;
                start = curStart;
            }
        } else {
            lg = 0;
        }
    }

    if (lgmax == 0) {
        fout << 0;
    } else {
        for (int i = 0; i < lgmax; i++) {
            fout << invSir[start + i];
        }
    }

    return 0;
}
