#include <cstdio>
#include <cstring>

#define MAX_LINIE 201
#define MAX_NUMAR 1000000 // dimensiune suficientă pentru numere mari ca șir

// Adună două șiruri mari de cifre, rezultatul în `rez`
// a și b sunt siruri de cifre
void adunaSiruri(const char *a, const char *b, char *rez) {
    int la = strlen(a);
    int lb = strlen(b);
    int i = la - 1, j = lb - 1, k = 0, t = 0;
    char tmp[MAX_NUMAR];
    while (i >= 0 || j >= 0 || t) {
        int x = (i >= 0 ? a[i--]-'0' : 0);
        int y = (j >= 0 ? b[j--]-'0' : 0);
        int s = x + y + t;
        tmp[k++] = (s % 10) + '0';
        t = s / 10;
    }
    // inversăm tmp în rez
    for (int p = 0; p < k; p++) {
        rez[p] = tmp[k-1-p];
    }
    rez[k] = '\0';
}

// Inmulteste un sir mare (numar) cu un int
void inmultireSirInt(const char *numar, int factor, char *rez) {
    int ln = strlen(numar);
    int t = 0, k = 0;
    char tmp[MAX_NUMAR];
    for (int i = ln-1; i >= 0; i--) {
        int x = (numar[i]-'0')*factor + t;
        tmp[k++] = (x%10)+'0';
        t = x/10;
    }
    while (t) {
        tmp[k++] = (t%10)+'0';
        t /= 10;
    }
    for (int i = 0; i < k; i++) {
        rez[i] = tmp[k-1-i];
    }
    rez[k] = '\0';
}

// Transformă un text în număr concatenând codurile ASCII ale literelor mici
void textInNumar(const char *text, char *rez) {
    int k = 0;
    for (int i = 0; text[i]; i++) {
        char c = text[i];
        if (c >= 'a' && c <= 'z') {
            int val = (int)c;
            char buf[4]; // maxim 3 cifre + '\0'
            sprintf(buf, "%d", val);
            for (int j = 0; buf[j]; j++) {
                rez[k++] = buf[j];
            }
        }
    }
    rez[k] = '\0';
}

// Gaseste cea mai lunga secventa de cifre impare
void secventaMaxImpare(const char *numar, char *rez) {
    int k = 0, maxL = 0, start = 0, s = 0;
    int ln = strlen(numar);
    for (int i = 0; i < ln; i++) {
        if ((numar[i]-'0')%2 == 1) {
            if (k == 0) s = i;
            k++;
            if (k > maxL) {
                maxL = k;
                start = s;
            }
        } else {
            k = 0;
        }
    }
    for (int i = 0; i < maxL; i++) {
        rez[i] = numar[start+i];
    }
    rez[maxL] = '\0';
}

int main() {
    FILE *fin = fopen("egipt.in","r");
    FILE *fout = fopen("egipt.out","w");

    int n;
    fscanf(fin, "%d\n", &n);

    char total[MAX_NUMAR];
    total[0] = '0'; total[1] = '\0';

    char linie[MAX_LINIE];
    char numar[MAX_NUMAR];

    for (int i = 0; i < n; i++) {
        fgets(linie, MAX_LINIE, fin);
        int ln = strlen(linie);
        if (linie[ln-1] == '\n') linie[ln-1] = '\0';
        textInNumar(linie, numar);
        char temp[MAX_NUMAR];
        strcpy(temp, total);
        adunaSiruri(temp, numar, total);
    }

    int anRege;
    fscanf(fin, "%d", &anRege);

    char inmultit[MAX_NUMAR];
    inmultireSirInt(total, anRege, inmultit);

    char parola[MAX_NUMAR];
    secventaMaxImpare(inmultit, parola);

    fprintf(fout, "%s\n", parola);

    fclose(fin);
    fclose(fout);

    return 0;
}
