//Cretu Constantin
#include <fstream>
#include <algorithm>
using namespace std;

ifstream fin("ferma.in");
ofstream fout("ferma.out");

#define MAX 16

int main() {
    int C, N, G;            // C=cerinta, N=numar porci, G=greutate maxima remorca
    int g[MAX];              // greutatile porcilor
    int a[MAX]={0};          // atribuire curenta: 0,1,2 pentru fiecare porc
    int b[MAX]={0};          // cea mai buna atribuire (lexicografic minim)
    int s[3]={0};            // sumele celor 3 transporturi pentru cea mai buna solutie
    int dif_min=100000;      // diferenta minima intre transporturi

    // --- Citire date ---
    fin >> C >> N >> G;
    for(int i=1;i<=N;i++) fin >> g[i];

    // --- Generare toate combinatiile posibile cu metoda succesorului ---
    while(!a[0]){ // continuam pana cand primul element devine nenul
        int sum[3]={0};     // sumele transporturilor curente
        bool ok=true;       // verificare daca greutatile nu depasesc G

        // calcul sumele pentru combinatia curenta
        for(int i=1;i<=N;i++){
            sum[a[i]] += g[i];
            if(sum[a[i]]>G){ ok=false; break; } // depasire greutate => abandon
        }

        // daca toate transporturile au cel putin un porc si nu depasesc G
        if(ok && sum[0] && sum[1] && sum[2]){
            // calcul diferenta maxima intre cele 3 transporturi
            int dif = max({abs(sum[0]-sum[1]), abs(sum[0]-sum[2]), abs(sum[1]-sum[2])});

            // daca diferenta este mai mica decat diferenta minima gasita
            if(dif<dif_min){
                dif_min=dif;
                for(int i=0;i<3;i++) s[i]=sum[i];       // salvam sumele
                for(int i=0;i<=N;i++) b[i]=a[i];        // salvam atribuirea
            } else if(dif==dif_min){
                // daca dif este egal, verificam lexicografic minim
                int k=1; while(k<=N && a[k]==b[k]) k++;
                if(k<=N && a[k]<b[k]) for(int i=0;i<=N;i++) b[i]=a[i];
            }
        }

        // --- succesor: generam urmatoarea combinatie ---
        int i=N;
        while(a[i]==2){ a[i]=0; i--; } // resetam pana gasim element de incrementat
        if(i>=1) a[i]++; else break;     // daca s-a terminat, iesim din loop
    }

    // --- Afisare rezultate ---
    if(C==1){
        sort(s,s+3);                        // ordonare crescatoare
        fout << s[0]<<' '<<s[1]<<' '<<s[2]<<'\n';
    } else if(C==2){
        for(int i=1;i<=N;i++){
            if(i>1) fout<<' ';
            fout << b[i]+1;                 // afisam transportul pentru fiecare porc
        }
        fout<<'\n';
    } else fout<<dif_min<<'\n';            // C==3: diferenta minima intre transporturi

    return 0;
}
