//Hadimbu Stelian
#include <fstream>
using namespace std;

int C, N;
long long G;

long long g[16];      // greutatile porcilor
int sol[16];          // solutia curenta (1,2,3)
int Sol2[16];         // solutia optima (pentru C=2)

long long S1f, S2f, S3f;
long long Difmin;

int main() {
    ifstream fin("ferma.in");
    ofstream fout("ferma.out");

    fin >> C >> N >> G;
    for (int i = 0; i < N; i++)
        fin >> g[i];

    Difmin = 2e9;
    for (int i = 0; i < N; i++)
        Sol2[i] = 3;

    // initial: toate valorile 1 (transport 1)
    for (int i = 0; i < N; i++)
        sol[i] = 1;

    // numar total de configuratii = 3^N
    long long total = 1;
    for (int i = 0; i < N; i++)
        total *= 3;

    for (long long k = 0; k < total; k++) {

        long long s1 = 0, s2 = 0, s3 = 0;

        // calcul sume
        for (int i = 0; i < N; i++) {
            if (sol[i] == 1) s1 += g[i];
            else if (sol[i] == 2) s2 += g[i];
            else s3 += g[i];
        }

        // verificare capacitate
        if (s1 <= G && s2 <= G && s3 <= G) {

            long long mx = s1;
            if (s2 > mx) mx = s2;
            if (s3 > mx) mx = s3;

            long long mn = s1;
            if (s2 < mn) mn = s2;
            if (s3 < mn) mn = s3;

            long long diff = mx - mn;

            if (diff < Difmin) {
                Difmin = diff;
                S1f = s1; S2f = s2; S3f = s3;

                for (int i = 0; i < N; i++)
                    Sol2[i] = sol[i];
            }
            else if (diff == Difmin) {
                // comparar lexicografic
                int ok = 0;
                for (int i = 0; i < N; i++) {
                    if (sol[i] < Sol2[i]) { ok = 1; break; }
                    if (sol[i] > Sol2[i]) break;
                }
                if (ok) {
                    S1f = s1; S2f = s2; S3f = s3;
                    for (int i = 0; i < N; i++)
                        Sol2[i] = sol[i];
                }
            }
        }

        int pos = 0;
        while (pos < N) {
            sol[pos]++;
            if (sol[pos] <= 3) break;
            sol[pos] = 1;
            pos++;
        }
    }

    if (C == 3) {
        fout << Difmin << "\n";
    }
    else if (C == 1) {
        long long a = S1f, b = S2f, c = S3f;

        if (a > b) swap(a, b);
        if (b > c) swap(b, c);
        if (a > b) swap(a, b);

        fout << a << " " << b << " " << c << "\n";
    }
    else {
        for (int i = 0; i < N; i++) {
            if (i) fout << " ";
            fout << Sol2[i];
        }
        fout << "\n";
    }
    return 0;
}
