#include <iostream>
#include <fstream>

using namespace std;

ifstream fin("brad.in");
ofstream fout("brad.out");

int bestBrad[30]; 
bool bestExista = false; 
int indexBest = 0;

int curent[120];  

bool verificaValiditate(int lungime) {
    if (lungime != 26) return false;

    int frecventa[27] = {0};

    for (int i = 0; i < 26; i++) {
        if (curent[i] < 1 || curent[i] > 26) return false;

        if (frecventa[curent[i]] == 1) return false;

        frecventa[curent[i]] = 1;
    }
    return true;
}

bool esteMaiFrumos() {
    for (int i = 0; i < 26; i++) {
        if (curent[i] < bestBrad[i]) return true;
        if (curent[i] > bestBrad[i]) return false;
    }
    return false;
}

int main() {
    int n;
    fin >> n;

    for (int i = 1; i <= n; i++) {
        int x, k = 0;

        while (fin >> x && x != 0) {
            curent[k++] = x;
        }

        if (verificaValiditate(k)) {
            if (!bestExista || esteMaiFrumos()) {
                indexBest = i;
                bestExista = true;
                for (int j = 0; j < 26; j++) {
                    bestBrad[j] = curent[j];
                }
            }
        }
    }

    fout << indexBest;

    fin.close();
    fout.close();
    return 0;
}